package conversions;
import java.awt.*;

public class DensityQuantity extends ObservableQuantity {
	
	private double value;
	
	private int type=0;

	private String units = "lb/in^3";

	private boolean metric = false;
	private String name = "";
	
	public boolean isMetric() {
		return metric;
	}
	
	public DensityQuantity(
		double _value, 
		String _name,
		int _type) {
		value = _value;
		name = _name;
		type=_type;
	}
	
	public double getValue() {
		return value;
	}
	
	
	public void setValue(double d) {
		convertToEnglish();
		if (value == d) return;
		value = d;
		setChanged();
		
	}
	public int getType() {
		return type;
	}
	
	public String getUnits() {
		return units;
	}
	public void convertToMetric() {
		if (metric == true) return;
		setChanged();
		metric = true;
		units = "kg/mm^3";
		value =
			value * .00002768;
	}
	public String toString() {
		return name+"=" + value + " "+units;
	}
	public void convertToEnglish() {
		if (metric == false) return;
		setChanged();

		metric = false;
		units = "lb-sec^3";
		value =
			value /.00002768;
	}
	
	
	public  void test() {

		System.out.println(this );
		convertToEnglish();
		System.out.println(this );
		convertToMetric();
		System.out.println(this);
	}		
 
		
}